package com.rocogz.syy.equity.entity.batchDistributionCouponApplyNode;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 清单工作流审批记录 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-12-16 10:43:52</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_batch_distribution_coupon_apply_detail_node")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityBatchDistributionCouponApplyDetailNode extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 节点编号
     */
    private String nodeCode;

    /**
     * 节点名称
     */
    private String nodeName;

    /**
     * 节点类型：APPROVE-审批，AUDIT-审核
     */
    private String nodeType;

    /**
     * 审批结果：ADD-提交申请，PASS-通过，DISAGREE-不通过，RETURN-退回，RECALL-我已撤回
     */
    private String nodeResult;

    /**
     * 审批结果中文名称
     */
    @TableField(exist = false)
    private String nodeResultLabel;

    /**
     * 审批结果颜色
     */
    @TableField(exist = false)
    private String nodeResultColor;

    /**
     * 批注
     */
    private String remark;

    /**
     * 审批人
     */
    private String approveUser;

    /**
     * 审批人姓名
     */
    private String approveName;

    /**
     * 审批人手机号
     */
    private String approveMobile;

    /**
     * 审批时间
     */
    private LocalDateTime approveTime;


}
