package com.rocogz.syy.equity.entity.grantObject;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 权益发放对象表 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-10-18 12:51:47</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_grant_object")
@JsonIgnoreProperties(ignoreUnknown = true)
public class EquityGrantObject extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 发放对象编号
     */
    private String code;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 姓名
     */
    private String name;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
