/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.equity;

import com.rocogz.util.DateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class EquityCommonUtil {
    public static LocalDateTime getEffectiveInvalidDateByMode(String model, String modeVal, String type, LocalDate pointDate) {
        LocalDateTime localDateTime = null;
        if ("NOW".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().toString() + " 00:00:00"));
        } else if ("POINT_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(modeVal + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        } else if ("LAST_DAY".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(LocalDate.now().plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        } else if ("POLICY_DATE".equals(model)) {
            localDateTime = DateUtil.formatDateStrToLocalDateTime((String)(pointDate.plusDays(Long.valueOf(modeVal)) + ("E".equals(type) ? " 00:00:00" : " 23:59:59")));
        }
        return localDateTime;
    }

    public static LocalDateTime getOrderInvalidDate(String orderInvalidModel, String orderInvalidValue, LocalDateTime userCouponInvalidDate) {
        if ("COUPON_LAST_DAY_INVALID".equals(orderInvalidModel)) {
            return userCouponInvalidDate.plusDays(Long.valueOf(orderInvalidValue));
        }
        return userCouponInvalidDate;
    }

    public static String convertTimeInRegion(Integer hour) {
        if (hour >= 0 && hour < 12) {
            return "AM";
        }
        if (hour >= 12 && hour < 18) {
            return "PM";
        }
        return "NIGHT";
    }

    private static String beforeSplit(String param, String value) {
        if (param.length() <= Integer.parseInt(value)) {
            return param;
        }
        return param.substring(0, Integer.parseInt(value));
    }

    private static String afterSplit(String param, String value) {
        if (param.length() <= Integer.parseInt(value)) {
            return param;
        }
        return param.substring(param.length() - Integer.parseInt(value), param.length());
    }

    public static String generateRuleSigna(Map<String, String> ruleMap, String name, String mobile, String licenseNo, String idCard) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
            if ("NAME".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)name)) {
                multiValueMap.add((Object)entry.getKey(), (Object)("Y".equals(entry.getValue()) ? name : ""));
            }
            if ("MOBILE_BEFORE_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)mobile)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.beforeSplit(mobile, entry.getValue()));
            }
            if ("MOBILE_AFTER_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)mobile)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(mobile, entry.getValue()));
            }
            if ("CARNUMBER_AFTER_N".equals(entry.getKey()) && StringUtils.isNotBlank((CharSequence)licenseNo)) {
                multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(licenseNo, entry.getValue()));
            }
            if (!"IDCARD_AFTER_N".equals(entry.getKey()) || !StringUtils.isNotBlank((CharSequence)idCard)) continue;
            multiValueMap.add((Object)entry.getKey(), (Object)EquityCommonUtil.afterSplit(idCard, entry.getValue()));
        }
        return EquityCommonUtil.signatureStr((MultiValueMap<String, String>)multiValueMap);
    }

    public static String generateRuleSigna(String name, String mobile, String licenseNo, String idCard) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"MOBILE_BEFORE_N", (Object)EquityCommonUtil.beforeSplit(mobile, "3"));
        multiValueMap.add((Object)"MOBILE_AFTER_N", (Object)EquityCommonUtil.afterSplit(mobile, "4"));
        multiValueMap.add((Object)"CARNUMBER_AFTER_N", (Object)EquityCommonUtil.afterSplit(licenseNo, "3"));
        multiValueMap.add((Object)"NAME", (Object)name);
        if (StringUtils.isNotBlank((CharSequence)idCard)) {
            multiValueMap.add((Object)"IDCARD_AFTER_N", (Object)EquityCommonUtil.afterSplit(idCard, "6"));
        }
        return EquityCommonUtil.signatureStr((MultiValueMap<String, String>)multiValueMap);
    }

    private static String signatureStr(MultiValueMap<String, String> parameters) {
        StringBuilder tempStr = new StringBuilder();
        TreeSet values = new TreeSet();
        for (String key : parameters.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)((List)parameters.get((Object)key)).get(0)))) continue;
            values.add(((List)parameters.get((Object)key)).get(0));
        }
        for (String val : values) {
            tempStr.append(val);
        }
        return tempStr.toString();
    }

    public static Map<String, String> batchDetailSearchSql(List<String> confitionList, String mobile, String name, String licenseNo) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer key = new StringBuffer();
        if (CollectionUtils.isNotEmpty(confitionList)) {
            if (confitionList.contains("MOBILE")) {
                sql.append(" AND detail.mobile='").append(mobile).append("'");
                key.append(mobile);
            }
            if (confitionList.contains("NAME")) {
                sql.append(" AND detail.name='").append(name).append("'");
                key.append(name);
            }
            if (confitionList.contains("LICENSE_NO_AFTER_THREE")) {
                licenseNo = StringUtils.isNotBlank((CharSequence)licenseNo) ? (licenseNo.length() > 3 ? licenseNo.substring(licenseNo.length() - 3, licenseNo.length()) : licenseNo) : null;
                sql.append(" AND detail.license_no like '%").append(licenseNo).append("'");
                key.append(licenseNo);
            }
            map.put("searchSql", sql.toString());
            map.put("paramKey", key.toString());
        }
        return map;
    }

    public static String pointUseRuleSql(String useRuleCode, String idCardExplicit, String name, String mobile, boolean isWithdrawals) {
        String searchSql = "";
        if (isWithdrawals) {
            if (StringUtils.isNotBlank((CharSequence)useRuleCode)) {
                String[] ruleCodeStr = useRuleCode.split("\\|");
                searchSql = searchSql + " AND point.use_rule_code='" + useRuleCode + "'";
                block10: for (int i = 0; i < ruleCodeStr.length; ++i) {
                    switch (ruleCodeStr[i]) {
                        case "NAME": {
                            searchSql = searchSql + " AND point.user_name='" + (StringUtils.isNotBlank((CharSequence)name) ? name : "") + "'";
                            continue block10;
                        }
                        case "PHONENUMBER": {
                            searchSql = searchSql + " AND point.mobile='" + (StringUtils.isNotBlank((CharSequence)mobile) ? mobile : "") + "'";
                            continue block10;
                        }
                        case "CARNUMBER": {
                            searchSql = searchSql + " AND point.id_card_explicit='" + (StringUtils.isNotBlank((CharSequence)idCardExplicit) ? idCardExplicit : "") + "'";
                            continue block10;
                        }
                    }
                }
            } else {
                searchSql = " AND point.use_rule_code is null ";
            }
        }
        return searchSql;
    }

    public static String convertNowDateToYear(LocalDate nowDate) {
        return String.valueOf(nowDate.getYear());
    }

    public static String convertCreatTimeToYear(LocalDateTime createTime) {
        return createTime.toString().substring(0, 4);
    }

    public static BigDecimal computeBusinessInsuranceRate(BigDecimal amount, BigDecimal businessInsurancePremium) {
        return Objects.nonNull(businessInsurancePremium) && businessInsurancePremium.compareTo(BigDecimal.ZERO) == 1 ? amount.divide(businessInsurancePremium, 4, RoundingMode.HALF_UP) : null;
    }

    public static String convertNodeTypeToStatus(String nodeType) {
        return "APPROVE".equals(nodeType) ? "PENDING_APPROVE" : "PENDING_AUDIT";
    }
}

