/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.equity.enumerate;

import com.rocogz.util.DateUtil;
import java.time.LocalDate;

public enum StatisTimeRangeEnum {
    ALL("\u5168\u90e8\u65f6\u95f4\u8303\u56f4"),
    TODAY("\u4eca\u65e5"){

        @Override
        public String getStartTime() {
            String today = DateUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd");
            return today + " 00:00:00";
        }

        @Override
        public String getEndTime() {
            String today = DateUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd");
            return today + " 23:59:59";
        }
    }
    ,
    THIS_MOUNT("\u672c\u6708"){

        @Override
        public String getStartTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue() < 10 ? "0" + now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String firstDayThisMonth = DateUtil.getFirstDayOfMonth((String)yearMonth);
            String dateTime = firstDayThisMonth + " 00:00:00";
            return dateTime;
        }

        @Override
        public String getEndTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue() < 10 ? "0" + now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String lastDayThisMonth = DateUtil.getLastDayOfMonth((String)yearMonth);
            String dateTime = lastDayThisMonth + " 23:59:59";
            return dateTime;
        }
    };

    private String label;

    private StatisTimeRangeEnum(String label) {
        this.label = label;
    }

    public String getStartTime() {
        return null;
    }

    public String getEndTime() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }
}

