package com.rocogz.syy.equity.dto.equity.recall;


import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.equity.EquityConstants;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.Arrays;
import java.util.List;

/**
 * <dl>
 * <dd>Description:进行审核请求 </dd>
 * <dd>@date: 2021/08/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class RecallApplyApproveReq {


    /**
     * 撤回申请单号
     */
    @NotBlank(message = "请传递撤回申请单号")
    private String recallCode;

    /**
     * 审核备注
     */
    private String approveRmk;

    /**
     * 审核最后的结果状态
     */
    @NotBlank(message = "请传递状态")
    private String status;
    /**
     * 审核人
     */
    @NotBlank(message = "请传操作人")
    private String operator;

    /**
     * 审核人姓名
     */
    private String operatorName;
    /**
     * 审核人手机号
     */
    private String operatorMobile;

    /**
     * 检查请求
     * @return
     */
    public Response checkReq() {

        if (StringUtils.isBlank(recallCode)) {
            return Response.failure("撤回申请单号缺失");
        }
        List<String> targetStatus = Arrays.asList(EquityConstants.DictEquityRecallApplyStatus.APPROVE_PASS,
                EquityConstants.DictEquityRecallApplyStatus.APPROVE_REFUSE);
        if (!targetStatus.contains(this.getStatus())) {
            return Response.failure("状态不正确");
        }

        return Response.succeed();
    }


    /**
     * 是否是审核拒绝
     * @return
     */
    public boolean approveRefuse() {

       return EquityConstants.DictEquityRecallApplyStatus.APPROVE_REFUSE.equals(this.getStatus());

    }


}
