package com.rocogz.syy.equity.dto.equity.statistics;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 代驾券使用统计 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-02-01 14:49:29</dd>
 * <dd>@author：andy</dd>
 * </dl>
 */
@Data
public class EquityDrivingServiceStatisticsDto {

    /**
     * 日期：yyyy-MM-dd或者yyyy-MM
     */
    private String reportDate;

    /**
     * 服务平台
     */
    private String miniAppid;

    /**
     * 服务平台Name
     */
    private String servicePlatformName;

    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 发放主体名称
     */
    private String sourceName;

    /**
     * 发放总张数：
     * 1:汇总统计：当前服务平台发放的代驾券总张数
     */
    private Integer totalGrantQuantity;

    /**
     * 使用总张数
     * 2:汇总统计：当前服务平台使用的代驾券总张数
     * 1:日报：当前服务平台当日使用的总张数
     * 1:月报：当前服务平台当月使用的总张数
     */
    private Integer totalUseQuantity;

    /**
     * 使用率：使用总张数/发放总张数
     * 3:汇总统计：使用总张数/发放总张数
     */
    private BigDecimal useQuantityRate;

    /**
     * 发放面值总额
     * 4:汇总统计：当前服务平台代驾券发放总额
     */
    private BigDecimal totalGrantFaceValue;

    /**
     * 使用总额
     * 5:汇总统计：当前服务平台代驾券已使用总额
     * 2:日报：当前服务平台当日已用的已用总额
     * 2:月报：当前服务平台当月已用的已用总额
     */
    private BigDecimal totalUseFaceValue;

    /**
     * 已使用的代驾券总面值
     * 3：日报：当前服务平台当日已用的原始面值总额
     * 3：月报：当前服务平台当月已用的原始面值总额
     */
    private BigDecimal totalAvailbleFaceValue;

    /**
     * 平均每张券使用的面额
     * 4:日报：当前服务平台当日已用的已用总额/使用总张数
     * 4:月报：当前服务平台当月已用的已用总额/使用总张数
     */
    private BigDecimal avgUseFaceValue;

    /**
     * 平均使用面额占比：
     * 6:汇总统计：使用总面额/发放面值总金额
     * 5：日报： 当前服务平台当日已用的已用总额/已用的原始总额
     * 5：月报： 当前服务平台当月已用的已用总额/已用的原始总额
     */
    private BigDecimal useFaceValueRate;

    /**
     * 平均每日使用张数：使用总张数/天数（该月已过天数，若当月则含查询报表当天）；
     * 若当天为2021-01-22，（2021年1月）天数为22，（2020年12月）的天数为31；
     * 6:月报：当前服务平台当月使用总张数/天数
     */
    private BigDecimal dayUseQuantity;

    /**
     * 平均每日使用面额：
     * 7：月报：当前服务平台当月已用的已用总额/天数
     */
    private BigDecimal dayUseFaceValue;

    /**
     * 统计加工时间
     */
    private LocalDateTime createTime;

}
