package com.rocogz.syy.equity.dto.equity.statistics;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 套餐券/电子油卡券/加油代金券/代驾券 发放统计 查询参数 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021-01-26 11:03:17</dd>
 * <dd>@author：zouzhicai</dd>
 * </dl>
 */
@Data
public class EquityStatisticsParamDto {

    /**
     * 服务平台
     */
    private String miniAppid;

    /**
     * 服务平台名称
     * 导出接口使用此字段接受平台名称，放入报表中
     */
    private String servicePlatformName;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL：正常发券
     */
    private String nature;

    /**
     * 报表类型 ALL 汇总报表、DAY 日报、MONTH 月报
     */
    private String reportType;

    /**
     * 发放主体编号
     */
    private List<String> sourceCodeList;

    /**
     * 权益编号
     */
    private String couponCode;

    /**
     * 权益名称
     */
    private String couponName;


    /**
     * 开始日期
     */
    private String startDate;

    /**
     * 结束日期
     */
    private String endDate;

    /**
     * 优惠券类型
     */
    private String typeCode;

    /**
     * 排序模式,日报跟月报第一次点击默认要传入，如果根据字段排序则不传：日报-D，月报-M
     */
    private String sortModel;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序类型  desc / asc / 空串
     */
    private String sortType;

    /**
     * 当前页数
     */
    private Integer page = 1;

    /**
     * 每页大小
     */
    private Integer limit = 10;
}
