package com.rocogz.syy.equity.dto.issuingBody;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author 尹世豪
 * @Description: 分页查询发放主体列表 请求dto
 * @Package com.rocogz.syy.equity.dto.issuingBody
 * @date 2022/10/25 9:56
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class IssuingBodyPageQueryDto {
    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 营业执照名称
     */
    private String name;

    /**
     * 主体显示名称
     */
    private String issuingBodyAbbreviation;

    /**
     * 主体业内名称
     */
    private String linkedBodyName;

    /**
     * 主体规范名称
     */
    private String abbreviation;

    /**
     * 上级主体编号
     */
    private String issuingBodyCodeP;

    /**
     * 所属服务商
     */
    private String belongAgent;

    /**
     * 主体类型
     */
    private String type;

    /**
     * 省编码字符串(有多个则用 , 分隔)
     */
    private String provinceCode;

    /**
     * 省编码列表
     */
    private List<String> provinceCodeList;

    /**
     * 市编码字符串(有多个则用 , 分隔)
     *
     */
    private String cityCode;

    /**
     * 市编码列表
     */
    private List<String> cityCodeList;

    /**
     * 区县编码字符串(有多个则用 , 分隔)
     */
    private String districtCode;

    /**
     * 区县编码列表
     */
    private List<String> districtCodeList;

    /**
     * 主体性质
     */
    private String whetherCustomer;

    /**
     * 企业类型(有多个则用 , 分隔)
     */
    private String enterpriseType;

    /**
     * 企业类型列表
     */
    private List<String> enterpriseTypeList;

    /**
     * 状态
     */
    private String status;

    /**
     * 发放主体权限
     */
    private List<String> issuingBodyPermissions;

    /**
     * 服务商权限
     */
    private List<String> agentPermissions;

    /**
     * 合作客户权限
     */
    private List<String> customerPermissions;

    /**
     * 当前页
     */
    private Integer page;

    /**
     * 每页记录数
     */
    private Integer limit;

    /**
     * 是否导出操作
     */
    private Boolean export;
}
