package com.rocogz.syy.equity.entity.template;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-03-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_template_column")
public class EquityIssuingTemplateColumn extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 模板主表code
     */
    private String templateCode;

    /**
     * 模板名称-通用的，不是通用的通过字典code关联查
     */
    private String templateName;

    /**
     * 发放主体code
     */
    private String issuingBodyCode;

    /**
     * 字典配置列，字典code
     */
    private String columnCode;

    /**
     * Y:必填，N非必填
     */
    private String required;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * Y:是，N:否
     */
    private String miniAppShow;

    /**
     * 标签编码
     * @see EquityIssuingTemplateLabel#code
     */
    private String labelCode;

    /**
     * 标签名称
     */
    @TableField(exist = false)
    private String labelName;




}
