package com.rocogz.syy.equity.entity.template;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.equity.dto.equity.template.TemplateColumnDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:权益模版标签管理</dd>
 * <dd>@date: 2022/05/24</dd>
 * <dd>@author: huhailong</dd>
 * <dd>场景：小程序模版标签管理</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_issuing_template_label")
public class EquityIssuingTemplateLabel  extends IdEntity {

    /**
     * 标签编码
     */
    public String code;

    /**
     * 标签名称
     */
    public String name;

    /**
     * 标签说明
     */
    public String introduce;

    /**
     * 默认标签 Y，N
     */
    public String defaultLabel;

    /**
     * OPEN 默认展开，LOCK 默认折叠
     */
    public String infoShowStatus;

    /**
     * 状态启用/停用 OPEN/LOCK
     */
    public String status;

    /**
     * 排序值
     */
    public Integer sort;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    /**
     * 小程序端：该标签组中包含的列
     */
    @TableField(exist = false)
    private List<TemplateColumnDto> miniAppColumnList;

}
