package com.rocogz.syy.equity.enumerate;

import com.rocogz.util.DateUtil;
import lombok.Getter;

import java.time.LocalDate;

/**
 * B端代理 礼赠->我的团队->个人数据统计
 * 统计时间范围（按照申请单创建时间统计）
 * @author zhangmin
 */
@Getter
public enum StatisTimeRangeEnum {

    ALL("全部时间范围"),

    TODAY("今日") {
        @Override
        public String getStartTime() {
            String today = DateUtil.format(LocalDate.now(), DateUtil.YYYY_MM_DD);
            return today + DateUtil.START_TIME;
        }

        @Override
        public String getEndTime() {
            String today = DateUtil.format(LocalDate.now(), DateUtil.YYYY_MM_DD);
            return today + DateUtil.END_TIME;
        }
    },

    THIS_MOUNT("本月") {

        @Override
        public String getStartTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue()<10? "0"+now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String firstDayThisMonth = DateUtil.getFirstDayOfMonth(yearMonth);
            String dateTime = firstDayThisMonth + DateUtil.START_TIME;
            return dateTime;
        }

        @Override
        public String getEndTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue()<10? "0"+now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String lastDayThisMonth = DateUtil.getLastDayOfMonth(yearMonth);
            String dateTime = lastDayThisMonth + DateUtil.END_TIME;
            return dateTime;
        }
    };

    private String label;

    StatisTimeRangeEnum(String label) {
        this.label = label;
    }


    public String getStartTime() {

        return null;
    }

    public String getEndTime() {

        return null;
    }

}
