/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.collect.Lists;
import com.rocogz.syy.common.entity.Account;
import com.rocogz.syy.infrastructure.entity.permission.Permission;
import com.rocogz.syy.infrastructure.entity.permission.UserDataPermission;
import com.rocogz.syy.infrastructure.entity.role.Role;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@TableName(value="basic_system_admin_user")
public class AdminUser
extends Account {
    private static final long serialVersionUID = 1L;
    private String name;
    private String mobile;
    private String email;
    private String status;
    private String registerTag;
    private String registerStatus;
    private LocalDateTime registerTime;
    private String keyword;
    private Boolean deleted;
    private transient List<Role> roles;
    private String active;
    private String uppass;
    private transient List<String> roleId;
    private transient List<UserDataPermission> userDataPermissions;
    private String systemCode;

    public AdminUser() {
    }

    public AdminUser(Integer id) {
        this.id = id;
    }

    public List<UserDataPermission> getUserDataPermissions() {
        return this.userDataPermissions;
    }

    public void setUserDataPermissions(List<UserDataPermission> userDataPermissions) {
        this.userDataPermissions = userDataPermissions;
    }

    public List<String> getRoleId() {
        return this.roleId;
    }

    public void setRoleId(List<String> roleId) {
        this.roleId = roleId;
    }

    public List<String> getRoleNameList() {
        if (CollectionUtils.isEmpty(this.roles)) {
            return Collections.emptyList();
        }
        ArrayList roleNames = Lists.newArrayListWithCapacity((int)this.roles.size());
        for (Role role : this.roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public LinkedHashSet<String> getPermissions() {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(this.roles)) {
            for (Role role : this.roles) {
                List<Permission> permission = role.getPermission();
                if (permission == null) continue;
                for (Permission perm : permission) {
                    permissions.add(perm.getViewPermission());
                    permissions.add(perm.getUrlPermission());
                }
            }
        }
        return permissions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getUppass() {
        return this.uppass;
    }

    public void setUppass(String uppass) {
        this.uppass = uppass;
    }

    public String getRegisterTag() {
        return this.registerTag;
    }

    public void setRegisterTag(String registerTag) {
        this.registerTag = registerTag;
    }

    public String getRegisterStatus() {
        return this.registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }

    public LocalDateTime getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(LocalDateTime registerTime) {
        this.registerTime = registerTime;
    }

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }
}

