package com.rocogz.syy.infrastructure.constant;

/**
 * <dl>
 * <dd>Description: 基础服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/20 11:43</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class InfrastructureConstant {
    private InfrastructureConstant(){}

    /**
     * 选择区域为全部时的编码
     */
    public static final String AREA_ALL_CODE = "AREA_ALL";

    public static final String MQ_EXCHANGE_NAME = "INFRASTRUCTURE_EXCHANGE";
    public static final String MQ_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_API_REQUEST_LOG";

    public static final String MQ_MALL_API_REQUEST_LOG_ROUTE_KEY = "MALL_API_REQUEST_LOG_KEY";
    public static final String MQ_MALL_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MALL_API_REQUEST_LOG_QUEUE";

    public static final String MQ_MERCHANT_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_QUEUE";
    public static final String MQ_MERCHANT_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_MERCHANT_API_REQUEST_LOG_KEY";

    public static final String MQ_AGENT_API_REQUEST_LOG_QUEUE = "INFRASTRUCTURE_AGENT_API_REQUEST_LOG_QUEUE";
    public static final String MQ_AGENT_API_REQUEST_LOG_ROUTE_KEY = "INFRASTRUCTURE_AGENT_API_REQUEST_LOG_KEY";

    /**
     * 字典表类型
     */
    public class DictType {
        public final static String USER_DATA_PERMISSION_TYPE = "USER_DATA_PERMISSION_TYPE";
    }

    /**
     * 字典表数据
     */
    public class DictData {

        /** 供应商，与用户权限表中data_type对应*/
        public final static String USER_DATA_PERMISSION_SUPPLIER = "SUPPLIER";
        public final static String USER_DATA_PERMISSION_SUPPLIER_LABEL = "供应商";

        /** 专区 */
        public final static String USER_DATA_PERMISSION_PREFECTURE = "PREFECTURE";
        public final static String USER_DATA_PERMISSION_PREFECTURE_LABEL = "专区";

        /** 平台商户 */
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS = "ISSUING_BUSINESS";
        public final static String USER_DATA_PERMISSION_ISSUING_BUSINESS_LABEL = "发放主体-平台商户";

        /**
         * 发放机构
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ORG = "ISSUING_ORG";
        public final static String USER_DATA_PERMISSION_ISSUING_ORG_LABEL = "发放主体-发放机构";

        /**
         * 合作企业
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE = "ISSUING_ENTERPRISE";
        public final static String USER_DATA_PERMISSION_ISSUING_ENTERPRISE_LABEL = "发放主体-合作企业";


        /**
         * 代理公司
         */
        public final static String USER_DATA_PERMISSION_ISSUING_AGENT_COMPANY = "ISSUING_AGENT_COMPANY";
        public final static String USER_DATA_PERMISSION_ISSUING_AGENT_COMPANY_LABEL = "发放主体-代理公司";

        /**
         * 4S店
         */
        public final static String USER_DATA_PERMISSION_ISSUING_ISSUING_CAR_SALE_SERVICE = "ISSUING_CAR_SALE_SERVICE";
        public final static String USER_DATA_PERMISSION_ISSUING_ISSUING_CAR_SALE_SERVICE_LABEL = "发放主体-4S店";


        /**
         * 结算主体
         */
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT = "SETTLE_SUBJECT";
        public final static String USER_DATA_PERMISSION_SETTLE_SUBJECT_LABEL = "结算主体";

        /**
         * 小程序
         */
        public final static String USER_DATA_PERMISSION_MINI_APP = "MINI_APP";
        public final static String USER_DATA_PERMISSION_MINI_APP_LABEL = "所属平台";

        /**
         * 团队
         */
        public final static String USER_DATA_PERMISSION_TEAM="P_TEAM";
        public final static String USER_DATA_PERMISSION_TEAM_LABEL = "团队";

        /**
         * 个人
         */
        public final static String USER_DATA_PERMISSION_SELF="P_SELF";
        public final static String USER_DATA_PERMISSION_SELF_LABEL = "个人";
        //自身权限特定的Code
        public final static String USER_DATA_PERMISSION_SELF_CODE="SELF";

    }


    public  static class DictRoleType {
        public static final String TYPE_CODE = "ROLE_TYPE";
        // 系统角色
        public static final String SYS = "system";
        // 平台角色
        public static final String PLATFORM = "platform";
        // 集成商角色
        public static final String BIZ = "biz";
    }


    public  static class DictPlatformRoleScope {
        public static final String TYPE_CODE = "PLATFORM_ROLE_SCOPE";
        // 所有平台
        public static final String ALL = "ALL";
        // 指定平台
        public static final String SPECIAL = "SPECIAL";
    }

    public  static class DictUserType {
        public static final String TYPE_CODE = "USER_TYPE";
        // 系统用户
        public static final String SYS = "system";
        // 平台用户
        public static final String PLATFORM = "platform";
        // 集成商用户
        public static final String BIZ = "biz";
    }
    public static class IsType{

        public static final String N = "N";

        public static final String Y = "Y";
    }


    public  static class DictIssuingBodyRoleScope {
        public static final String TYPE_CODE = "ISSUING_BODY_ROLE_SCOPE";
        // 所有发放主体
        public static final String ALL = "ALL";
        // 指定发放主体
        public static final String SPECIAL = "SPECIAL";
    }



    /**
     * 来源系统
     */
    public static class SourceSystemType  {

        // 后台管理系统
        public static final String ADMIN = "ADMIN";

        // 分销系统
        public static final String DISTRIBUTION = "DISTRIBUTION";
    }

    /**
     * 维护级别
     */
    public static class MaintainType  {
        // 平台级
        public static final String PLATFORM = "PLATFORM";
    }

    /**
     * 系统运行类型
     */
    public static class SystemRunType  {

        // 正常运转模式
        public static final String NORMAL = "NORMAL";

        // 系统升级模式
        public static final String UPGRADE = "UPGRADE";
    }

    /**
     * 系统升级类别
     */
    public static class SystemUpgradeType  {

        // 正常升级
        public static final String NORMAL = "NORMAL";

        // Bug紧急处理
        public static final String BUG = "BUG";
    }

    /**
     * 团队身份
     */
    public static class TeamPositionType{

        /**
         * 团队长
         */
        public static final String LEADER = "LEADER";

        /**
         * 团员
         */
        public static final String MEMBER = "MEMBER";
    }



    /**
     * 发放主体账号性质
     */
    public static class IssuingBodyUserNatureType{

        /**
         * 常规账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 特殊账户
         */
        public static final String SPECIFIC = "SPECIFIC";
    }

    /**
     * 发放主体账号类型
     */
    public static class IssuingBodyUserType{

        public static final String TYPE_CODE = "ISSUING_BODY_USER_TYPE";

        /**
         * 普通个人账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 团队管理员
         */
        public static final String TEAM_LEADER = "TEAM_LEADER";

        /**
         * 机构管理员
         */
        public static final String ENTERPRISE_LEADER = "ENTERPRISE_LEADER";
    }


    /**
     * 发放主体角色类型
     */
    public static class IssuingBodyRoleType{

        public static final String TYPE_CODE = "ISSUING_BODY_ROLE_TYPE";

        /**
         * 普通个人账号
         */
        public static final String  NORMAL = "NORMAL";

        /**
         * 团队管理员
         */
        public static final String TEAM_LEADER = "TEAM_LEADER";

        /**
         * 机构管理员
         */
        public static final String ENTERPRISE_LEADER = "ENTERPRISE_LEADER";
    }

}
