package com.rocogz.syy.infrastructure.dto.team;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author djt
 * @date 2021/3/24
 */
@Data
public class BasicTeamInfoEditDTO {

    /**
     * id
     */
    private Integer id;
    /**
     * 发放主体编号
     */
    @NotBlank
    @Length(max = 64)
    private String issuingBodyCode;

    /**
     * 团队名称
     */
    @NotBlank()
    @Length(max = 20)
    private String teamName;


    /**
     * 团队简称
     */
    @NotBlank
    @Length(max = 20)
    private String teamNameAbbreviation;

    /**
     * 团队状态
     */
    @NotBlank
    private String status;

    /**
     * 说明
     */
    @Length(max = 100)
    private String instructions;



    /**
     * 创建人
     */
    private Integer createUser;


    /**
     * 创建人用户名
     */
    private String createUserName;


    /**
     * 最后更新人
     */
    private Integer updateUser;


}
