package com.rocogz.syy.infrastructure.entity.systemRun;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 基础服务-系统运行模式管理
 * </p>
 *
 * @author luoyc
 * @since 2021-02-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class BasicSystemRunManage extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 服务平台编码
     */
    private String servicePlatformCode;

    /**
     * mini_appid
     */
    private String miniAppid;

    /**
     * 维护级别 NORMAL
     */
    private String maintainType;

    /**
     * 系统运行类型 NORMAL、UPGRADE
     */
    private String systemRunType;

    /**
     * 系统升级类别
     */
    private String systemUpgradeType;

    /**
     * 公告内容
     */
    private String content;

    /**
     * 备注
     */
    private String remark;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    @TableField(exist = false)
    private List<Integer> ids;

}
