package com.rocogz.merchant.entity.storeservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户服务项目套餐关联商户项目
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreServiceComboRelate extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户服务项目编码
     */
    private String serviceCode;

    /**
     * 套餐关联的商户服务项目编码
     */
    private String comboServiceCode;

    /**
     * 套餐服务对象
     */
    @TableField(exist = false)
    private MerchantStoreService comboService;
}
