package com.rocogz.merchant.entity.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.request.validity.ValidityRuleBaseSaveReq;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 产品使用有效期规则配置
 *
 * @@author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoodsValidityRule extends IdEntity {

    /**
     * 有效期规则编号
     */
    private String code;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户产品编号/ 服务商产品编号
     */
    private String productCode;

    /**
     * 有效期设置时点
     *
     * @see Constant.DictValiditySettingTimePoint#ISSUE
     */
    private String settingTimePoint;

    /**
     * 生效方式（IMMEDIATE：立即生效、DELAY：延时生效、DEFINITE：指定日期）
     * @see Constant.DictValidityGenerateWay#DELAY
     */
    private String effectiveRuleMode;

    /**
     * 生效方式指定日期（生效方式为指定日期时有值）
     */
    private LocalDate effectiveDate;

    /**
     * 生效方式: 延时生效天数（生效方式为延时生效时有值）
     */
    private Integer effectiveDelayDays;

    /**
     * 失效方式：（CALC_BY_GOOD：取平台产品有效期天数计算、 DELAY：生效xx天后失效、 DEFINITE：指定日期）
     * @see Constant.DictValidityInvalidGenerateWay#CALC_BY_GOOD
     */
    private String invalidRuleMode;

    /**
     * 失效方式：指定的失效日期（失效方式为指定日期时有值）
     */
    private LocalDate invalidDate;

    /**
     * 失效方式: 生效延迟xx天后失效（失效方式为延时生效时有值）
     */
    private Integer invalidDelayDays;


    /**
     * 规则类型(ISSUING_BODY:发放主体, SPECIFIC：指定产品)
     *
     * @see Constant.DictValidityRuleNature#ISSUING_BODY
     */
    private String ruleNature;

    /**
     * 触发调用上游的方式(MANUAL：手动、AUTO:自动)
     *
     * @see Constant.DictTriggerRemoteApiMode#MANUAL
     */
    private String remoteTriggerMode;

    /**
     * 规则启用/停用状态
     * @see Constant.DictData#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    public static MerchantGoodsValidityRule valueOf(ValidityRuleBaseSaveReq req){
        MerchantGoodsValidityRule rule = new MerchantGoodsValidityRule();
        BeanUtils.copyProperties(req,rule);
        return rule;
    }



}
