package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 下游订单结算日志表
 * </p>
 *
 * @author zhangmin
 * @since 2021-07-30
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantScmOrderSettleLog extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算批次号
     */
    private String batchCode;

    /**
     * 请求报文
     */
    private String reqBody;

    /**
     * 请求时间
     */
    private LocalDateTime reqTime;

    /**
     * 响应报文
     */
    private String respBody;

    /**
     * 响应时间
     */
    private LocalDateTime respTime;

    /**
     * 耗时(秒)
     */
    private Double spendSeconds;


    /**
     * 备注/异常信息
     */
    private String remark;

    /**
     * 是否成功
     */
    private Boolean succeed;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
