package com.rocogz.merchant.entity.supplier;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 供应商
 * </p>
 *
 * @author yifenrui
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_supplier")
public class MerchantSupplier extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 供应商编码
     */
    private String code;

    /**
     * 供应商名称
     */
    private String name;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 营业执照号
     */
    private String businessLicenseNo;

    /**
     * 营业执照图片
     */
    private String businessLicensePhoto;

    /**
     * 供应商介绍
     */
    private String introduce;

    /**
     * 状态
     */
    private String status;


    /**
     * 联系人
     */
    @TableField(exist = false)
    private List<MerchantSupplierContacts> contacts;


    /**
     * 营业执照名称
     */
    private String businessLicenseName;

    /**
     * 法人代表
     */
    private String legalRepresentative;


}
