package com.rocogz.merchant.request.goods;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.request.base.PageReq;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author djt
 * @date 2021/7/20
 */
@Data
public class BaseGoodsReq extends PageReq {

    private String name;

    private String code;

    private String status;

    private String belongIdentify;

    private List<String> excludeGoodsTypes;

    /**
     * 发放主体
     */
    private String issuingBodyCode;


    public Map<String,Object> toMap(){
        Map<String, Object> params = new HashMap<>(8);
        if (StringUtils.isNotBlank(this.name)){
            params.put("name", "%"+this.name+"%");
        }
        if (StringUtils.isNotBlank(this.code)){
            params.put("code", "%"+this.code+"%");
        }
        if (StringUtils.isNotBlank(this.status)){
            params.put("status", this.status);
        }
        if (StringUtils.isNotBlank(this.belongIdentify)){
            params.put("belongIdentify", this.belongIdentify);
        }
        if(this.excludeGoodsTypes != null && this.excludeGoodsTypes.size() > 0){
            params.put("excludeGoodsTypes",this.excludeGoodsTypes);
        }
        if (StringUtils.isNotBlank(this.issuingBodyCode)){
            params.put("issuingBodyCode", this.issuingBodyCode);
        }
        return params;
    }

}
