/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.comutil;

import java.time.LocalDate;
import org.springframework.lang.NonNull;

public final class ValidityUtil {
    private ValidityUtil() {
    }

    @NonNull
    public static LocalDate[] getValidityRange(@NonNull String generateValidityWay, LocalDate specifiedStartDate, LocalDate specifiedEndDate, Integer delayDays) {
        if ("DEFINITE".equals(generateValidityWay)) {
            if (specifiedStartDate == null || specifiedEndDate == null) {
                throw new IllegalArgumentException("\u6307\u5b9a\u65e5\u671f\u65b9\u5f0f\uff1a\u5fc5\u987b\u6307\u5b9a\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f");
            }
            if (specifiedEndDate.isBefore(specifiedStartDate)) {
                throw new IllegalArgumentException("\u6307\u5b9a\u7684\u7ed3\u675f\u65e5\u671f\u5fc5\u987b>=\u5f00\u59cb\u65e5\u671f");
            }
            return new LocalDate[]{specifiedStartDate, specifiedEndDate};
        }
        delayDays = Math.max(0, delayDays);
        LocalDate startDate = LocalDate.now();
        LocalDate endDate = startDate.plusDays(delayDays.intValue());
        return new LocalDate[]{startDate, endDate};
    }

    @NonNull
    public static LocalDate getValidityStartDate(@NonNull String generateValidityWay, LocalDate specifiedStartDate, Integer delayDays) {
        return ValidityUtil.doGetValidityDate(generateValidityWay, specifiedStartDate, LocalDate.now(), delayDays);
    }

    @NonNull
    public static LocalDate getValidityStartDate(@NonNull String generateValidityWay, LocalDate specifiedStartDate, LocalDate baseDate, Integer delayDays) {
        return ValidityUtil.doGetValidityDate(generateValidityWay, specifiedStartDate, baseDate, delayDays);
    }

    @NonNull
    public static LocalDate getValidityEndDate(@NonNull String generateValidityWay, LocalDate specifiedEndDate, LocalDate validityStartDate, Integer delayDays) {
        if (delayDays != null && delayDays >= 1) {
            delayDays = delayDays - 1;
        }
        return ValidityUtil.doGetValidityDate(generateValidityWay, specifiedEndDate, validityStartDate, delayDays);
    }

    @NonNull
    public static String getValidityStatus(@NonNull LocalDate validityStartDate, @NonNull LocalDate validityEndDate) {
        LocalDate now = LocalDate.now();
        if (now.isAfter(validityEndDate)) {
            return "EXPIRED";
        }
        if (now.isBefore(validityStartDate)) {
            return "INEFFECTIVE";
        }
        return "EFFECTIVE";
    }

    public static boolean isExpired(@NonNull LocalDate validityStartDate, @NonNull LocalDate validityEndDate) {
        return "EXPIRED".equals(ValidityUtil.getValidityStatus(validityStartDate, validityEndDate));
    }

    private static LocalDate doGetValidityDate(String generateValidityWay, LocalDate specifiedDate, LocalDate baseDate, Integer delayDays) {
        if ("IMMEDIATE".equals(generateValidityWay)) {
            return baseDate;
        }
        if ("DEFINITE".equals(generateValidityWay)) {
            if (specifiedDate == null) {
                throw new IllegalArgumentException("\u6307\u5b9a\u65e5\u671f\u65b9\u5f0f\uff1a\u5fc5\u987b\u6307\u5b9a\u751f\u6548/\u5931\u6548\u65e5\u671f");
            }
            return specifiedDate;
        }
        delayDays = Math.max(0, delayDays);
        return baseDate.plusDays(delayDays.intValue());
    }
}

