package com.rocogz.merchant.client.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发放产品订单参数
 * @author：zhangmin
 * @since：2022/3/16
 */
@Data
@Accessors(chain = true)
public class UpdateThirdBizCodeAndIncrSaleQtyDto {

    /**
     * 主订单编码
     */
    private String orderCode;

    /**
     * 订单Item编码
     */
    private String orderItemCode;

    private Boolean isSuite;

    /**
     * 是否需要发放用户券
     */
    private Boolean needIssueCoupon;

    /**
     * 是否需要 库存逻辑，如果为true, 并且所有的上游订单都成功了 则需要增加销量
     */
    private Boolean needStock;

}
