package com.rocogz.merchant.client.storeservice;

import com.rocogz.syy.common.request.PageRequestParameter;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * 商户服务项目参数
 * @author：liangyongtong
 * @since：2021/1/13
 */
@Setter
@Getter
@Accessors(chain = true)
public class ReqStoreService extends PageRequestParameter {
    /** 查询关键字 */
    private String keyword;
    /** 查询编码 */
    private String code;
    /** 不包含编码 */
    private String excludedCode;
    /** 服务分类编码 */
    private String cataCode;
    /** 商户编码 */
    private String storeCode;
    /** 状态 */
    private String status;
    /** 服务分类数据 */
    private boolean isServiceCataData = false;
    /** 服务项目标签数据 */
    private boolean isServiceLabelData = false;
    /** 指标数据 */
    private boolean isStoreServiceKpiData = false;
    /** 价格数据 */
    private boolean isPricesData = false;
    /** 查询来源 */
    private String source;
    /** id desc */
    private boolean idDesc = false;
}
