package com.rocogz.merchant.dto.report;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.merchant.enumerate.ReportSearchScmOrderDataType;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zhangmin
 * 统计报表：搜索需要的scm订单原数据
 */
@Setter
@Getter
public class SearchReportScmOrderParamDto {

    /**
     * 查询的日期窗口:查询：发放日期、领取日期、日期撤回 = dateWindow (排除当日发放当日撤回)
     * pattern:yyyy-MM-dd
     */
    @NotNull
    private String dateWindow;

    /**
     * 如果传入了指定的主体，则查询指定主体的数据
     */
    private List<String> issuingBodyCodeList;


    /**
     * 查询数据类型
     */
    private ReportSearchScmOrderDataType dataType;

    /**
     * 页大小
     */
    private Integer limit = 20;

    /**
     * 当前页
     */
    private Integer page = 1;


    public String getStartDateTime() {
        return dateWindow + " 00:00:00";
    }

    public String getEndDateTime() {
        return dateWindow + " 23:59:59";
    }


    public String getDataTypeValue() {
        if(dataType == null) {
            return StringUtils.EMPTY;
        }
        return dataType.name();
    }
}
