package com.rocogz.merchant.dto.scm.correction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 数据矫正：scm下游订单中的 客户产品 dto
 * @author zhangmin
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class CorrectCustomerProductDto {

    /**
     * 主体编号
     */
    private String issuingCode;

    /**
     * 合作客户编号
     */
    private String customerCode;


    /**
     * 调整前客户产品编号
     */
    private String oldCustomerProductCode;

    /**
     * 调整前客户产品名称
     */
    private String oldCustomerProductName;


    /**
     * 调整前服务商产品编号
     */
    private String oldAgentProductCode;

    /**
     * 调整前服务商产品名称
     */
    private String oldAgentProductName;

    /**
     * 调整前平台产品编号
     */
    private String oldPlatformProductCode;

    /**
     * 调整前平台产品名称
     */
    private String oldPlatformProductName;

    /**
     * 调整前采购结算价
     */
    private BigDecimal oldPurchaseSettlePrice;



    /**
     * 调整后客户产品编号
     */
    private String newCustomerProductCode;

    /**
     * 调整后客户产品名称
     */
    private String newCustomerProductName;


    /**
     * 调整后服务商产品编号
     */
    private String newAgentProductCode;

    /**
     * 调整后服务商产品名称
     */
    private String newAgentProductName;

    /**
     * 调整后平台产品编号
     */
    private String newPlatformProductCode;

    /**
     * 调整后平台产品名称
     */
    private String newPlatformProductName;


    /**
     * 调整后采购结算价
     */
    private BigDecimal newPurchaseSettlePrice;

}
