package com.rocogz.merchant.dto.scm.didi;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 定时任务更新使用有效,返回结果Dto
 *
 * @@author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
public class ExpireDidiCouponResultDto {

    /**
     * 供应链下游订单号
     */
    private String scmOrderCode;

    /**
     * 供应链订单类型
     */
    private String orderType;

    /**
     * 供应链订单的产品类型
     */
    private String productType;

    /**
     * 供应链订单的产品品牌
     */
    private String brandCode;

    /**
     * 发放手机号
     */
    private String grantMobile;

    /**
     * 该用户券状态的核销状态都是 未核销状态的 && 是没有被撤回的， 用来查询滴滴的券是否已使用，如果滴滴那边已使用了，则更新为已使用，并把权益系统的用户券更新为已使用
     */
    private List<String> rocoUserCouponCodes;


}
