package com.rocogz.merchant.dto.scm.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 备付金账户对应上游订单列表
 * @author：liangyongtong
 * @since：2021/4/25
 */
@Data
@Accessors(chain = true)
public class ScmCoverAccountOrderDto implements Serializable {

    /**
     * 流水号
     */
    private String tradeFlowCode;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 交易金额
     */
    private BigDecimal tradeAmount;

    /**
     * 交易时间
     */
    private LocalDateTime tradeTime;

    /**
     * 下单时间
     */
    private LocalDateTime orderTime;

    /**
     * 明细订单编码
     */
    private String orderItemCode;

    /**
     * 主订单编码
     */
    private String orderCode;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 合作客户产品采购价格
     */
    private BigDecimal customerPurchasePrice;

    /**
     * 合作客户市场价
     */
    private BigDecimal customerMarketPrice;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 代理商产品采购价格
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理产市场价
     */
    private BigDecimal agentMarketPrice;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 下单人编码
     */
    private String createUser;

    /**
     * 发放主体团队编码
     */
    private String teamCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放客户
     */
    private String sourceCustomer;

    /**
     * 备付金扣减客户编号
     */
    private String dedutionCustomerCode;
}
