package com.rocogz.merchant.dto.scm.order;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @author djt
 * @date 2022/3/10
 */
@Data
@Accessors(chain = true)
public class ScmDateDeferReq {

    /**
     * 延期类型
     */
    @NotBlank
    private String deferType;

    /**
     * 唯一标识(领取延期传下游订单号,使用延期传用户券编号)
     */
    @NotBlank
    private String identificationCode;

    /**
     * 生效日期
     */
    @NotNull
    private LocalDateTime effectiveDate;

    /**
     * 失效日期
     */
    @NotNull
    private LocalDateTime invalidDate;

    /**
     * 产品性质(单品/套餐)
     */
    private String  productNature;

}
