package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 统计报表汇总：汇总报表 查看发放清单列表 搜索参数
 * @author zhangmin
 */
@Setter
@Getter
public class ScmSearchSettleOrderRespDto {


    // ===  订单信息  ====

    /**
     * 订单编号:例如：SCM20210721000003
     */
    private String orderCode;

    /**
     * 发放时间：调用供应链订单系统下单时间
     */
    private LocalDateTime grantTime;

    /**
     * 下游订单发放状态
     *
     * @see Constant.DictData#SCM_ORDER_STATUS_SUCCESS
     */
    private String orderStatus;

    private String orderStatusLabel;


    /**
     * 发放成功时间
     */
    private LocalDateTime grantSuccessTime;


    /**
     * 发放张数
     */
    private Integer quantity;

    /**
     * 订单总金额/商品总面值
     */
    private BigDecimal totalPrice;

    /**
     * 结算状态
     *
     * @see Constant.DictSettleStatus#UN_SETTLE
     */
    private String settleStatus;

    private String settleStatusLabel;

    /**
     * 完成结算时间
     */
    private LocalDateTime settleTime;

    /**
     * 结算批次号
     */
    private String settleBatchCode;

    /**
     * 结算的金额
     */
    private BigDecimal settledAmount;


    // ===  订单的用户信息  ====

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 发放会员证件类型
     */
    private String grantIdtype;

    /**
     * 发放会员证件信息
     */
    private String grantIdno;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 发放会员保单号
     */
    private String policyNumber;

    /**
     * 真实会员手机号
     */
    private String realMobile;


    // ===  产品信息  ====


    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 合作客户产品采购价格
     */
    private BigDecimal customerPurchasePrice;

    /**
     * 合作客户产品市场价/面额
     */
    private BigDecimal customerMarketPrice;

    /**
     * 合作客户结算采购价
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 代理商产品采购价格
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理商产品市场价/面额
     */
    private BigDecimal agentMarketPrice;

    /**
     * 代理商结算采购价
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 平台产品名称
     */
    private String productName;

    /**
     * 产品性质:单品,供应商定制套餐、平台定制套餐
     *
     * @see Constant.DictData#GOODS_NATURE_ITEM
     */
    private String productNature;

    /**
     * 产品类别：加油代金券、电子油卡券直充
     *
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     * @see MerchantGoods#goodsType
     */
    private String productType;

    /**
     * 产品类别-名称
     */
    private String productTypeName;

    /**
     * 权益编号：基准券编号,例如：CP2021011900000001
     */
    private String couponCode;


    // ===  发放机构信息  ====


    /**
     * 申请人 用户名
     */
    private String createUser;

    /**
     * 申请人名字
     */
    private String createName;

    /**
     * 申请创建时间
     */
    private LocalDateTime createTime;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体简称
     */
    private String issuingBodyShortName;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 团队简称
     */
    private String teamShortName;

    /**
     * 申请单号,即发放业务单号,例如：BD2021010600000001
     */
    private String applyNo;

    /**
     * 清单编号：例如：BD2021010600000001_1
     */
    private String businessCode;

    /**
     * 发放来源平台：SYY
     */
    private String grantPlatform;

    /**
     * 发放目标平台,微信小程序的servicePlatformCode
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 目标小程序名称
     */
    private String targetMiniAppidName;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;


}
