package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:库存取消请求 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockCancelReq {

    /**
     * 操作账户编号
     */
    @NotBlank
    private String operator;

    /**
     * 要占用/出库取消的产品列表
     */
    @Valid
    @NotEmpty
    private List<ScmGoodsStockCancelItemDto> goodsList;

    /**
     * 操作时间
     */
    private LocalDateTime updateTime;
}
