package com.rocogz.merchant.dto.scmWarehouse.warehouse;

import com.rocogz.merchant.constant.ScmWarehouseConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * <dl>
 * <dd>Description:仓库创建请求 </dd>
 * <dd>@date: 2022/03/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmWarehouseCreateReq {

    /**
     * 仓库名称
     */
    @NotBlank
    private String name;
    /**
     * 仓库类型
     * @see ScmWarehouseConstant.DictScmWarehouseType#TYPE_CODE
     */
    @NotBlank
    private String whType;
    /**
     * 拥有方编号:主体编号/合作客户编号/服务商编号
     * 要与对应的类型仓库类型匹配
     */
    private String ownerCode;

    /**
     * 合作客户编码，这个字段针对创建的是主体仓时使用。
     * 如果创建的是主体仓，则需要将对应的合作客户编号保存，方便批量入库时查询产品列表
     */
    private String customerCode;
    /**
     * 状态
     */
    @NotBlank
    private String status;
    /**
     * 操作人
     */
    @NotBlank
    private String operator;

}
