package com.rocogz.merchant.entity.areaservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 专区服务项目结算主表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAreaServiceSettlement extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 结算信息编码
     */
    private String settlementCode;

    /**
     * 专区服务项目编码
     */
    private String areaServiceCode;

    /**
     * 专区编码
     */
    private String areaCode;

    /**
     * 专区名称
     */
    private String areaName;

    /**
     * 主要用于保存的时候提交对应的专区列表
     */
    @TableField(exist = false)
    private List<MerchantAreaServiceRelate> relates;

    /**
     * 结算商编码
     */
    private String settleCode;

    /**
     * 结算商名称
     */
    private String settleName;

    /**
     * 结算方式
     */
    private String settleWay;

    /**
     * 是否区分车型 Y/N
     */
    private String distinguish;

    /**
     * 介绍
     */
    private String introduce;

    /**
     * 对应的结算价格
     */
    @TableField(exist = false)
    private List<MerchantAreaServiceSettlementPrice> prices;
}
