package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 从上游订单获取数据，重新处理备付金领取扣减退款流程
 * </p>
 *
 * @author liangyongtong
 * @since 2021-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmCoverData extends IdEntity {

    private static final long serialVersionUID = -103134081738720069L;

    /**
     * 下游订单编号
     */
    private String orderCode;

    /**
     * 上游订单编号
     */
    private String orderItemCode;

    /**
     * 上游订单扣减金额
     */
    private BigDecimal price;

    /**
     * 备付金扣减的合作客户编号
     */
    private String dedutionCustomerCode;

    /**
     * 发放、领取、扣减、退款
     * @see Constant.DictData#COVER_DATA_TYPE_GRANT
     */
    private String operateType;

    /**
     * 客户编号
     */
    private String customerCode;

    /**
     * 未处理、已处理、处理中、处理失败
     * @see Constant.DictData#COVER_DATA_STATUS_UNPROCESSED
     */
    private String status;

    /**
     * 处理时间
     */
    private LocalDateTime opTime;

    /**
     * 批次号
     */
    private String batchNo;

}
