package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.goods.MerchantGoodsMeal;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 供应商套餐明细【子表】
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderComboDetail extends IdEntity {

    private static final long serialVersionUID = -6611663976856795238L;
    /**
     * 下游订单号
     * @see MerchantScmOrderInformation#orderCode
     */
    private String orderCode;

    /**
     * 上游订单号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号:唯一编号
     * 发放用户券时,关联的是用户券发放信息的如下字段
     * @see com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponLaunchInfo#grantOrderCode
     */
    private String comboOrderItemCode;

    /**
     * 套餐明细产品编码,即套餐下包含的子商品的平台产品编号
     * 发放用户券时,发放的用户类型 就是 该子产品的平台产品类型，所以发放的券的类型是 子产品的类型
     * @see MerchantGoodsMeal#mealGoodsCode
     */
    private String productCode;

    /**
     * 第三方产品编码,例如： 对应滴滴套餐中子产品编号
     */
    private String thirdProductCode;

    /**
     * 第三方券号, 例如
     * （1）鼎聚返回的powerNo
     * （2）滴滴打车券的券编号
     *  @see com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponInfo#thirdCode  把第三方 业务券号 更新到 roco用户券的thirdCode字段
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;

    /**
     * 平台套餐产品编码:即父产品平台编号
     * @see MerchantGoodsMeal#goodsCode
     */
    private String comboProductCode;

    /**
     * 用户券发放状态:
     * @see Constant.DictData#SCM_USER_COUPON_GRANT_STATUS_PENDING
     */
    private String userCouponGrantStatus;

    /**
     * 用户券发放重试次数
     */
    private Integer userCouponGrantRetryNum;

    /**
     * 用户券发放异常原因
     */
    private String userCouponGrantErrorReason;

    /**
     * 订单核销状态:
     * @see com.rocogz.merchant.constant.Constant.DictData#SCM_ORDER_WRITE_OFF_STATUS_WRITE_OFF
     */
    private String writeOffStatus;

    /**
     * 订单核销时间
     */
    private LocalDateTime writeOffTime;

    /**
     * 订单金额，即套餐中子商品的市场价
     * @see MerchantGoodsMeal#marketPrice
     */
    private BigDecimal detailPrice;

    /**
     * 第三方业务编号更新到权益中心状态
     */
    private String powerNoToEquityStatus;

    /**
     * 第三方业务编号更新到权益中心执行次数
     */
    private Integer powerNoToEquityNum;

    /**
     * 订单状态,开始用户券发放成功时，会更新为成功
     * @see Constant.DictData#SCM_ORDER_STATUS_SUCCESS
     */
    private String orderStatus;


    /**
     * 平台产品延迟多少天失效,就是套餐子产品的使用有效期天数
     * @see MerchantGoods#useValidity
     */
    private Integer useValidityInvalidDelayDays;

    /**
     * 供应商套餐 明细产品的 使用有效期：
     *  开始日期 = MerchantScmOrderDetail#useValidityStartDate  = 发放的平台产品设置的使用有效期开始日期
     */
    private LocalDate  useValidityStartDate;

    /**
     *  供应商套餐 明细产品的使用有效期结束日期 = 用 套餐子产品的 useValidityInvalidDelayDays 计算失效日期
     */
    private LocalDate  useValidityEndDate;

    /**
     *使用有效期状态：未生效，已生效，已过期
     * @see Constant.DictValidityStatus#INEFFECTIVE
     */
    private String useValidityStatus;

    /**
     * 已延期次数，默认为0
     */
    private Integer deferCnt;


    //=== 下面的属性用来传值

    //产品订单发放平台信息
    private transient MerchantScmInformation scmGrantInfo;

    //产品订单 目标用户表
    private transient MerchantScmTargetUser scmGrantTargetUser;

    private transient MerchantScmProductInformation scmProductInfo;

    private transient MerchantScmOrderInformation scmOrder;
}
