package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmWarehouse;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * scmOrder库存信息
 * </p>
 *
 * @author zhangmin
 * @since 2022-03-15
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantScmOrderStock extends IdEntity {


    /**
     * 下游订单号
     */
    private String orderCode;

    /**
     * 仓库编号
     *
     * @see MerchantScmWarehouse#code
     */
    private String warehouseCode;

    /**
     * 产品编号
     * （1） 如果是主体仓库或客户仓库,则存入合作客户产品编号
     * (2) 如果是服务商仓库，则存入 服务商产品编号
     * (3) 如果是平台仓库，则存入平台产品编号
     */
    private String productCode;


    /**
     * 库存占用状态,供应链下单成功时，占用库存
     * @see Constant.DictScmOrderStockStatus
     */
    private String occupyStockStatus;

    /**
     * 库存占用失败原因
     */
    private String occupyStockFailReason;

    /**
     * 库存占用尝试次数
     */
    private Integer occupyStockRetryNum;


    /**
     * 增加库存销量 状态
     * @see Constant.DictScmOrderStockStatus
     */
    private String changeSaleQtyStatus;


    /**
     * 增加库存销量 失败原因
     */
    private String changeSaleQtyFailReason;

    /**
     * 增加库存销量 尝试次数
     */
    private Integer changeSaleQtyRetryNum;


    /**
     * 撤回下游订单时：库存退回状态
     * @see  Constant.DictScmOrderStockStatus
     */
    private String refundStockStatus;

    //以下是非PO属性
    private transient MerchantScmInformation scmInfo;
    private transient MerchantScmProductInformation scmProduct;
}
