package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 申请操作日志
 * </p>
 *
 * @author yinshihao
 * @since 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmReissueApplyLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 处理动作
     */
    private String action;

    /**
     * 操作时间
     */
    private LocalDateTime time;

    /**
     * 操作人
     */
    private String user;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;


}
