package com.rocogz.merchant.entity.store;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author zhangmin
 * 门店专区 关联关系表：多对多关联
 */
@Setter
@Getter
@Accessors(chain = true)
public class MerchantStoreArea extends IdEntity {

    /**
     * 门店编号
     */
    private String storeCode;

    /**
     * 专区编码
     */
    private String areaCode;

    /**
     * 专区名称
     */
    private String areaName;

    /**
     * 专区所属平台
     */
    private String miniAppid;


    /**
     * 专区所属平台名称,页面显示使用
     */
    private transient String miniAppName;

}
