package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.industry.MerchantIndustry;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户行业信息
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreIndustry extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 行业编码
     */
    private String industryCode;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 品牌对象
     */
    @TableField(exist = false)
    private MerchantBrand brand;

    /**
     * 行业对象
     */
    @TableField(exist = false)
    private MerchantIndustry industry;

    /**
     * 行业描述: 存储为 json
     */
    private String industryDetail;


}
