package com.rocogz.merchant.dto;

import com.rocogz.merchant.entity.store.MerchantStoreBusinessSection;
import com.rocogz.merchant.entity.store.MerchantStoreLabel;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 加油站列表
 * @author ：liangyongtong
 * @since ：2020/6/29
 */
@Data
@Accessors(chain = true)
@NoArgsConstructor
@RequiredArgsConstructor(staticName = "of")
public class GasStationDto implements Serializable {

    private static final long serialVersionUID = -2037851234211176063L;
    /**
     * 商户编码
     */
    @NonNull
    private String code;

    /**
     * 纬度
     */
    @NonNull
    private String lat;

    /**
     * 经度
     */
    @NonNull
    private String lng;

    /**
     * 名称
     */
    private String name;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 图片 品牌图片路径
     */
    private String url;

    /**
     * 距离
     */
    private Integer distance;

    /**
     * 城市
     */
    private String city;

    /**
     * 商户类型
     */
    private String type;

    /**
     * 商户标签
     */
    private List<String> labels;

    /**
     * 营业时间
     */
    private String businessTime;

    /**
     * 停业类型
     */
    private List<MerchantStoreBusinessSection> sections;

    /**
     * 油品型号标签
     */
    private List<MerchantStoreLabel> oilModelLabels;

    /**
     * 便利店标签
     */
    private List<MerchantStoreLabel> convenienceLabels;

    /**
     * 油站标签
     */
    private List<MerchantStoreLabel> oilTypeLabels;

    /**
     * 活动介绍
     */
    private String activeIntroduction;

    /**
     * 是否活动
     */
    private String active;
}
