package com.rocogz.merchant.dto.customer;

import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 客户管理树
 * @author：liangyongtong
 * @since：2021/2/3
 */
@Data
@Accessors(chain = true)
public class CategoryTreeDto implements Serializable {
    /** 标题 */
    private String title;

    /** id */
    private String id;

    /** 右侧信息展示  true表示展示列表,false表示展示详情*/
    private Boolean rightInfo;

    /** 上级机构名称 */
    private String pName;

    /** 上级机构编码 */
    private String pCode;

    private MerchantCooperationCustomer customer;

    private String status;

    /** 叶子节点 */
    private List<CategoryTreeDto> children;
}
