package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:库存占用请求 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockOccupyReq {

    /**
     * 操作人
     */
    @NotBlank
    private String operator;

    /**
     * 占用库存的产品列表
     */
    @Valid
    @NotEmpty
    private List<ScmGoodsStockOccupyItemDto> goodsList;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
