package com.rocogz.merchant.entity.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:商户商品库存 </dd>
 * <dd>@date: 2020/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoodsStockLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String  goodsCode;


    /**
     * 调整的库存
     */
    private Integer adjustStock;

    /**
     * 操作项
     */
    private String logType;

    /**
     * 信息
     */
    private String logContent;

    /**
     * 操作人
     */
    private String logUser;

    /**
     * 操作时间
     */
    private LocalDateTime logTime;

}
