package com.rocogz.merchant.client.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单退款
 * @author：liangyongtong
 * @since：2021/4/26
 */
@Data
@Accessors(chain = true)
public class ReqOrderRefund implements Serializable {

    /**
     * 下游订单号（主订单号）
     */
    private String orderCode;

    /**
     * 上游订单号（明细订单编码）
     */
    private String orderItemCode;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 退款流水号
     */
    private String tradeFlowCode;

    /**
     * 操作人
     */
    private String username;
}
