package com.rocogz.merchant.client.scm.starCharge;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 星星充电-卡券发放
 */
@Data
@Accessors(chain = true)
public class StarChargeCouponProvideResp {

    /**
     * 操作结果
     * 0:成功;1：失败
     * @see com.rocogz.merchant.constant.StarChargeConstant#Succ_Stat_SUCCESS
     */
    @JsonProperty(value = "SuccStat")
    private Integer SuccStat;

    /**
     * 失败原因
     * 1：企业不存在
     * 2：用户不存在
     * 3：集采编号不存在
     */
    @JsonProperty(value = "FailReason")
    private Integer FailReason;

    /**
     * 失败原因描述
     */
    @JsonProperty(value = "FailReasonMsg")
    private String FailReasonMsg;

    /**
     * 券集合
     */
    @JsonProperty(value = "Coupons")
    private List<StarChargeCoupon> Coupons;

}
