package com.rocogz.merchant.constant;



/**
 * <dl>
 * <dd>Description:分销仓库常量 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
public final class ScmWarehouseConstant {


    public static final String Default_PLATFORM_NAME = "平台仓";


    public static final String PLATFORM_WH_TYPE = DictScmWarehouseType.PLATFORM;

    /**
     * Redis缓存键值
     */
    public class RedisKey {

        /**
         * 仓库中库存冻结
         */
        public static final String SCM_STOCK_FROZEN_LOCK_KEY="scm:stock:frozen:lock:";

        /**
         * 解冻，占用，出库，取消使用业务单号作为锁
         */
        public static final String SCM_STOCK_BIZ_LOCK_KEY="scm:stock:biz:";

        /**
         * 仓库中库存解冻
         */
        public static final String SCM_STOCK_UNFROZEN_LOCK_KEY="scm:stock:unfrozen:lock:";

        /**
         * 创建仓库的锁
         */
        public static final String SCM_WAREHOUSE_CREATE_LOCK_KEY="scm:wh:create:lock:";

        /**
         * 获取仓库查询锁
         */
        public static final String SCM_WAREHOUSE_QUERY_LOCK_KEY="scm:wh:query:lock:";

        /**
         * 仓库商品添加锁
         */
        public static final String SCM_WAREHOUSE_GOODS_INIT_KEY="scm:wh:goods:init:lock:";

    }

    /**
     * 分销库存流类型
     */
    public static final class DictScmStockFlowType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_FLOW_TYPE";

        /**
         * 库存出库
         */
        public static final String STOCK_OUT = "STOCK_OUT";

        /**
         * 库存入库
         */
        public static final String STOCK_IN = "STOCK_IN";

        /**
         * 库存预警
         */
        public static final String STOCK_WARN = "STOCK_WARN";

    }

    /**
     * 分销库存流类型
     */
    public static final class DictScmStockFlowEndStatusType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_FLOW_END_STATUS_TYPE";

        /**
         * 已完结
         */
        public static final String END_Y = "Y";

        /**
         * 未完结
         */
        public static final String END_N = "N";


    }


    /**
     * 分销库存流阶段类型
     */
    public static final class DictScmStockFlowStageType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_FLOW_STAGE_TYPE";

        /**
         * 库存冻结
         */
        public static final String  FROZEN = "FROZEN";
        /**
         * 库存解冻
         */
        public static final String UNFROZEN = "UNFROZEN";

        /**
         * 占用库存
         */
        public static final String OCCUPY = "OCCUPY";

        /**
         * 销售出库
         */
        public static final String SALE_OUT="SALE_OUT";

        /**
         * 预警库存增加
         */
        public static final String WARN="WARN";

        /**
         * 可售增加，手动调整库存/调拨
         */
        public static final String STOCK_ADD="STOCK_ADD";

        /**
         * 可售减少，手动调整库存/调拨
         */
        public static final String STOCK_REDUCE="STOCK_REDUCE";

        /**
         * 取消库存：可能是出库取消/占用取消
         */
        public static final String CANCEL="CANCEL";

    }

    /**
     * 分销库存流日志操作类型
     */
    public static final class DictScmStockFlowLogOperateType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_FLOW_LOG_OPERATE_TYPE";

        /**
         * 冻结库存
         */
        public static final String  FROZEN= "FROZEN";

        /**
         * 解冻库存
         */
        public static final String  UNFROZEN= "UNFROZEN";

        /**
         * 占用库存
         */
        public static final String  OCCUPY= "OCCUPY";

        /**
         * 产品出库
         */
        public static final String SALE_OUT="SALE_OUT";

        /**
         * 占用库存取消
         */
        public static final String  CANCEL_OCCUPY= "CANCEL_OCCUPY";

        /**
         * 销售库存取消
         */
        public static final String  CANCEL_OUT= "CANCEL_OUT";

        /**
         * 手动增加库存
         */
        public static final String  MANUAL_ADD ="MANUAL_ADD";

        /**
         * 批量入库
         */
        public static final String MANUAL_BATCH_ADD = "MANUAL_BATCH_ADD";

        /**
         * 手动减少库存
         */
        public static final String  MANUAL_REDUCE ="MANUAL_REDUCE";

        /**
         * 批量出库
         */
        public static final String MANUAL_BATCH_REDUCE = "MANUAL_BATCH_REDUCE";

        /**
         * 预警库存调整
         */
        public static final String  ADJUST_WARN = "ADJUST_WARN";

        /**
         * 调拨出库
         */
        public static final String ALLOCATE_OUT = "ALLOCATE_OUT";

        /**
         * 调拨入库
         */
        public static final String ALLOCATE_IN = "ALLOCATE_IN";

    }


    /**
     * 调整库存的类型
     */
    public static final class DictScmStockAdjustType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_ADJUST_TYPE";

        /**
         * 预警库存调整，但不出出现在字典数据中
         */
        public final static String WARN = "WARN";

        /**
         * 后台的增加库存调整，出现在字典数据中
         */
        public final static String ADD_STOCK = "ADD_STOCK";

        /**
         * 后台减少库存调整，出现在字典数据中
         */
        public final static String REDUCE_STOCK = "REDUCE_STOCK";

    }

    /**
     * 调拨的状态类型
     */
    public static final class DictAllocateStatusType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_STOCK_ALLOCATE_STATUS";

        /**
         * 待调拨
         */
        public static final String PENDING_ALLOCATE = "PENDING_ALLOCATE";

        /**
         * 处理中
         */
        public static final String IN_PROCESS = "IN_PROCESS";

        /**
         * 调拨失败
         */
        public static final String ALLOCATE_FAIL = "ALLOCATE_FAIL";

        /**
         * 已完成
         */
        public static final String ALLOCATE_SUCCESS = "ALLOCATE_SUCCESS";
    }


    /**
     * 仓库的类型
     */
    public static final class DictScmWarehouseType{

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "SCM_WAREHOUSE_TYPE";

        /**
         * 平台仓
         */
        public static final String PLATFORM = "PLATFORM";

        /**
         * 主体仓库
         */
        public static final String ISSUING_BODY = "ISSUING_BODY";

        /**
         * 客户仓库
         */
        public static final String CUSTOMER = "CUSTOMER";

        /**
         * 服务商仓库
         */
        public static final String AGENT = "AGENT";

    }






}
