package com.rocogz.merchant.dto.customer.goods.workflow.apply;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 申请入库dto
 * @date：2023/7/20
 * @author：huangdeyi
 */
@Data
public class GoodsInstoreApplyDto {

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 机构编码，即合作客户编码
     */
    private String customerCode;

    /**
     * 申请人用户名 : reference basic_system_admin_user.username
     */
    private String applierUser;

    /**
     * 申请人用户id : reference basic_system_admin_user.id
     */
    private int applierUserId;

    /**
     * 申请人手机号 : reference basic_system_admin_user.mobile
     */
    private String applierMobile;

    /**
     * 申请人名字 : reference basic_system_admin_user.name
     */
    private String applierName;

    /**
     * 产品列表
     */
    private List<GoodsInstoreApplyGoodsDto> goods;

    /**
     * 是否是新增/编辑申请时,是否是保存草稿,如果是保存草稿，就不启动工作流,申请单状态是DRAFT
     */
    private transient Boolean saveDraft;


    /**
     * 申请入库产品信息dto
     */
    @Data
    public static class GoodsInstoreApplyGoodsDto {

        /**
         * 产品编号
         */
        private String goodsCode;

        /**
         * 额度采购价
         */
        private BigDecimal quotaPurchaseUnitPrice;
    }
}
