package com.rocogz.merchant.dto.issuingBody.goodsConfigPool;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:配置的查询请求 </dd>
 * <dd>@date: 2023/07/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class MerchantIssuingBodyGoodsPoolConfigQueryReq {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 产品库类型T_WH总行库，SUB_WH分行库
     *
     * 一个主体最多只能配置一个类型
     * @see Constant.IssuingBodyGoodsPoolWarehouseBelongType#TYPE_CODE
     */
    private String proWhBelongType;

    /**
     * 费用类型列表
     * 可以传递的值商户基础
     * @see Constant.IssuingBodyGoodsPoolWarehouseFeelType#TYPE_CODE
     */
    private List<String> feeTypeList;

    /**
     * 载入客户名称
     */
    private Boolean loadRelName;

}
