package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 电卡 更新使用状态 dto
 * @author zhangmin
 * 更新使用状态
 */
@Setter @Getter
public class UpdateUseStatusDto {


    /**
     * 上游订单编码
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String orderItemCode;


    /**
     * 使用状态：未使用，部分使用、已使用（只有油卡,积分类型的，并且使用有效期过期后才会更新此字段）
     * 现在的业务：只是使用有效期过期后,调用interface查询油卡余额接口更新此字段
     * @see Constant.DictUseStatus
     */
    private String useStatus;


    /**
     * 使用状态更新时间, 只要更新为 部分使用，或已使用 需要更新此字段
     */
    private LocalDateTime useUpdateTime;

}
