package com.rocogz.merchant.entity.brand;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.industry.MerchantIndustry;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 商户品牌
 * </p>
 *
 * @author yinshihao
 * @since 2020-03-30
 */
@TableName(value = "merchant_brand")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class MerchantBrand extends UserTimeEntity {

    /**
     * 中国石油品牌编号
     */
    public static final String ZGSY = "zgsy";

    /**
     * 壳牌品牌编号
     */
    public static final String SHEL = "SHEL";

    /**
     * 中油ZYBP品牌编号
     */
    public static final String ZYBP = "ZYBP";

    /**
     * ROCO品牌编号
     */
    public static final String ROCO = "ROCO";


    /**
     * 曹曹出行
     */
    public static final String  CAOCAO = "caocao";

    /**
     * 滴滴打车
     */
    public static final String  DIDI = "didi";


    /**
     * 支付宝
     */
    public static final String  ALIPAY = "ALIPAY";


    /**
     * 电卡产品，星星充电
     */
    public static final String  StarCharge = "StarCharge";

    /**
     * 电卡产品，南网电卡
     */
    public static final String NWDK =  "NWDK";


    private static final long serialVersionUID=1L;

    /**
     * 品牌编号
     */
    private String code;

    /**
     * 品牌名称
     */
    private String name;

    /**
     * 品牌简称
     */
    private String abbreviation;

    /**
     * 封面地址
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String logoPath;

    /**
     * 所属行业编码
     */
    @TableField(exist = false)
    private List<String> industryCode;

    /**
     * 所属行业
     */
    @TableField(exist = false)
    private List<MerchantIndustry> industry;

    /**
     * 品牌介绍
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String description;

    /**
     * 状态
     */
    private String status;
}
