package com.rocogz.merchant.entity.channel.product;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 扣款主体实体类
 * @date：2021/11/23
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("merchant_deduct_subject")
public class MerchantDeductSubject extends IdEntity {

    private static final long serialVersionUID = 408456967298481911L;

    /**
    * 扣款主体编码
    */
    private String code;

    /**
     * 扣款主体名称
     */
    private String name;
    
    /**
    * 关联的平台code
    */
    private String platformCode;
    
    /**
    * 状态
    */
    private String status;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private Integer createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private Integer updateUser;

    /**
     * 创建人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 所属平台
     */
    @TableField(exist = false)
    private String platformName;

    /**
     * 参数列表
     */
    @TableField(exist = false)
    private List<MerchantDeductSubjectParams> deductSubjectParams;

    /**
     * 把参数转换为Map
     * @return
     */
    public Map<String, String> deductSubjectParamsToMap() {
        Map<String, String> map = new HashMap<>(8);
        if (CollectionUtils.isNotEmpty(this.deductSubjectParams)) {
            this.deductSubjectParams.forEach(p -> map.put(p.getParamName(), p.getParamValue()));
        }
        return map;
    }
}